class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'Suite 101'
    oldest_article = 7
    max_articles_per_feed = 100
    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

    remove_tags_before = dict(id='')
    remove_tags = [dict(name='div', attrs={'class':['','']}),
                   dict(name='div', attrs={'id':['','',]}),
                   dict(name='img'),]

    feeds          = [(u'Health and Wellness', u'http://rss.suite101.com/healthandwellness_section.xml'), 
                          (u'Latest Articles', u'http://rss.suite101.com/latestarticles.xml'), 
                          (u'Technology', u'http://rss.suite101.com/technology_section.xml')
                          ]
						  
    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup

    def print_version(self, url):
        return url + "?template=article_print.cfm"
